import { useTranslation } from 'react-i18next';
import { Select, SelectContent, SelectGroup, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { ControllerRenderProps } from 'react-hook-form';
import { FormParam } from '@/components/source/types';

export default function QueryDropdown(field: ControllerRenderProps<FormParam, 'time_range'>) {
  const { t } = useTranslation();

  const options = [
    { label: t('Last 2 Hours'), value: '2h' },
    { label: t('Last 4 Hours'), value: '4h' },
    { label: t('Last 6 Hours'), value: '6h' },
    { label: t('Last 12 Hours'), value: '12h' },
    { label: t('Last 24 Hours'), value: '24h' },
    { label: t('Last 2 Days'), value: '2d' },
    { label: t('Last Week'), value: '1w' },
    { label: t('Last Month'), value: '1m' },
    { label: t('Custom Elapsed Time'), value: 'custom elapsed time' },
  ];

  return (
    <div className="col-span-2 w-full">
      <Select
        value={field.value}
        onValueChange={(selectedVal) => {
          field.onChange(selectedVal);
        }}
      >
        <SelectTrigger className="w-full">
          <SelectValue placeholder="" />
        </SelectTrigger>
        <SelectContent>
          <SelectGroup className="max-h-80 w-full">
            {options.map((options, index) => (
              <SelectItem key={index} value={options.value}>
                {options.label}
              </SelectItem>
            ))}
          </SelectGroup>
        </SelectContent>
      </Select>
    </div>
  );
}
