export type Source = {
  id: number;
  name: string;
  description?: string;
  port?: number;
  flowtype?: string;
  directory?: string;
  status?: boolean;
  diskusage?: string;
  lifetime?: string;
  traffic?: string;
};

type SummaryDataPoint = {
  date: string;
  bytes: number;
  flows: number;
  packets: number;
  bps: number;
};

type TopTalker = {
  dstip: string;
  srcip: string;
  dstport: string;
  srcport: string;
  bytespercent: string;
  [key: string]: string;
};

type RechartsMouseEvent = { activeLabel?: string };

export type QuerySummary = {
  total_flows: number;
  total_bytes: number;
  total_packets: number;
  avg_bps: number;
  avg_pps: number;
  avg_bpp: number;
};

export type QueryResults = {
  flow_start: string;
  flow_end: string;
  duration: number;
  srcip: string;
  dstip: string;
  srcport: number;
  dstport: number;
  packets: number;
  bytes: number;
  flows: number;
  bitspersec: number;
  packetspersec: number;
  bytesperpacket: number;
};

export type QueryResponse = {
  summary: QuerySummary;
  results: QueryResults[];
};

export type QueryParam = {
  sources: Source[];
  raw_query: string;
  flow_start: string;
  flow_end?: string;
};

export type TimeRangeKey = '2h' | '4h' | '6h' | '12h' | '24h' | '2d' | '1w' | '1m' | 'custom elapsed time';

export type FormParam = QueryParam & {
  time_range: TimeRangeKey; //| 'custom date range'
};

type TopTalkersSummaryProps = {
  summaryTalkers: Record<string, TopTalker[] | undefined>;
  isLoading: boolean;
};
