import { useDeleteSourceGroups } from '@/components/sourcegroups/queries';
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from '@/components/ui/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';

export default function DeleteNmapScanDialog({
  ids,
  children,
  open,
  onOpenChange,
}: {
  ids: number[];
  children: React.ReactNode;
  open?: boolean;
  onOpenChange?: (open: boolean) => void;
}) {
  const { t } = useTranslation();
  const deleteSourceGroups = useDeleteSourceGroups();

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle>
            {' '}
            {ids.length > 1 ? t('Confirm Flow Source Groups Deletion') : t('Confirm Flow Source Group Deletion')}
          </AlertDialogTitle>
          <AlertDialogDescription>
            {ids.length > 1
              ? t(
                  'Are you sure you want to delete these flow source groups? This will not delete the sources associated with these groups.'
                )
              : t(
                  'Are you sure you want to delete this flow source group? This will not delete the sources associated with the group.'
                )}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
          <AlertDialogAction onClick={() => deleteSourceGroups.mutate(ids)}>{t('Delete')}</AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
}
