import { Skeleton } from '@/components/ui/skeleton';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Sheet, SheetContent, SheetHeader, SheetTitle, SheetDescription } from '@/components/ui/sheet';
import { Table, TableBody, TableHead, TableHeader, TableRow, TableCell } from '@/components/ui/table';
import { useTranslation } from 'react-i18next';

interface DetailSheetSkeletonProps {
  isOpen: boolean;
  onOpenChange: (open: boolean) => void;
  title?: string;
  description?: string;
}

export function DetailSheetSkeleton({ isOpen, onOpenChange, title, description }: DetailSheetSkeletonProps) {
  const { t } = useTranslation();
  return (
    <Sheet open={isOpen} onOpenChange={onOpenChange}>
      <SheetContent className="p-0 sm:max-w-[800px]">
        <div className="h-full p-4">
          <SheetHeader>
            <SheetTitle>{title}</SheetTitle>
            <SheetDescription>{description}</SheetDescription>
          </SheetHeader>
          <div className="mt-4 h-full">
            <Tabs defaultValue="details" className="h-full">
              <div className="mb-2 flex items-center space-x-2">
                <TabsList className="w-full">
                  <TabsTrigger value="details" className="w-1/2">
                    {t('Details')}
                  </TabsTrigger>
                  <TabsTrigger value="json" className="w-1/2">
                    {t('JSON')}
                  </TabsTrigger>
                </TabsList>
              </div>
              <TabsContent value="details">
                <Table className="w-full">
                  <TableHeader>
                    <TableRow>
                      <TableHead>{t('Field')}</TableHead>
                      <TableHead>{t('Value')}</TableHead>
                    </TableRow>
                  </TableHeader>
                  <TableBody>
                    {Array.from({ length: 15 }).map((_, i) => (
                      <TableRow key={i}>
                        <TableCell>
                          <Skeleton className="h-4 w-24" />
                        </TableCell>
                        <TableCell>
                          <Skeleton className="h-4 w-48" />
                        </TableCell>
                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </TabsContent>
              <TabsContent value="json">
                <div className="p-4">
                  <Skeleton className="mb-2 h-4 w-full" />
                  <Skeleton className="mb-2 h-4 w-full" />
                  <Skeleton className="mb-2 h-4 w-3/4" />
                  <Skeleton className="h-4 w-1/2" />
                </div>
              </TabsContent>
            </Tabs>
          </div>
        </div>
      </SheetContent>
    </Sheet>
  );
}
