import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogDescription,
  DialogFooter,
  DialogTrigger,
  DialogClose,
} from '@/components/ui/dialog';
import { Button } from '@/components/ui/button';
import { Trash2 } from 'lucide-react';
import { useTranslation } from 'react-i18next';
import { useDeleteSuricataData } from '@/components/suricata/data/queries';
import { Tooltip, TooltipTrigger, TooltipContent } from '@/components/ui/tooltip';

export function DeleteDataDialog({ jsonFile }: { jsonFile: string }) {
  const { t } = useTranslation();
  const { mutate: deleteSuricataData } = useDeleteSuricataData();
  const handleDelete = () => {
    deleteSuricataData({ jsonFile });
  };
  return (
    <Dialog>
      <Tooltip>
        <TooltipTrigger asChild>
          <DialogTrigger asChild>
            <Button size="icon" variant="outline">
              <Trash2 />
            </Button>
          </DialogTrigger>
        </TooltipTrigger>
        <TooltipContent>{t('Delete Suricata Data')}</TooltipContent>
      </Tooltip>
      <DialogContent>
        <DialogHeader>
          <DialogTitle>{t('Delete Suricata Data')}</DialogTitle>
          <DialogDescription>
            {t(
              'Are you sure you want to delete all data from {{jsonFile}}? This action cannot be undone and will delete both the file and the database entries.',
              { jsonFile }
            )}
          </DialogDescription>
        </DialogHeader>
        <DialogFooter>
          <DialogClose asChild>
            <Button variant="outline">{t('Cancel')}</Button>
          </DialogClose>
          <DialogClose asChild>
            <Button onClick={handleDelete}>{t('Delete Data')}</Button>
          </DialogClose>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
}
