import { useRuleDelete } from '@/components/suricata/rules/queries';
import {
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
} from '@/components/ui/alert-dialog';
import { useTranslation } from 'react-i18next';

export default function DeleteRulesAlert({ sid }: { sid: string }) {
  const { t } = useTranslation();
  const deleteRule = useRuleDelete();
  return (
    <AlertDialogContent>
      <AlertDialogHeader>
        <AlertDialogTitle>{t('Confirm Rule Deletion')}</AlertDialogTitle>
        <AlertDialogDescription>{t('Are you sure you want to delete this rule?')}</AlertDialogDescription>
      </AlertDialogHeader>
      <AlertDialogFooter>
        <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
        <AlertDialogAction
          onClick={() => {
            deleteRule.mutate(sid);
          }}
        >
          {t('Delete')}
        </AlertDialogAction>
      </AlertDialogFooter>
    </AlertDialogContent>
  );
}
