export type SuricataRule = {
  action: string;
  protocol: string;
  'source ip': string;
  'source port': string;
  direction: string;
  'destination ip': string;
  'destination port': string;
  status: string;
  options: Record<string, unknown>;
};

export type SuricataRules = {
  rules: {
    action: string;
    protocol: string;
    'source ip': string;
    'source port': string;
    direction: string;
    'destination ip': string;
    'destination port': string;
    status: 'Active' | 'Inactive';
    SID: string;
  }[];
};

export type selectedRulesFile = {
  selectedFile: string;
};

export type ToggleRuleParams = {
  sids: string | string[];
  toggleMode: string;
};

export type editRulesParam = {
  original_sid: string;
  new_rule: Record<string, unknown>;
};

export type Rule = SuricataRules['rules'][number];

export type Page = {
  rules: Rule[];
  total: number;
  page: number;
  pageSize: number;
};

export type SuricataData = {
  pages: Page[];
};

export type RuleOptionsProps = {
  sid: string;
};
