import { Button } from "@/components/ui/button"
import { Table } from "@tanstack/react-table"
import { useState } from "react";
import { useTranslation } from "react-i18next"
import { Select, SelectTrigger, SelectContent, SelectItem, SelectValue } from "@/components/ui/select"
import { DataTableRowAction } from "@/components/ui/DataTable/DataTable"

interface DataTableRowSelectionProps<TData> {
    table: Table<TData>;
    actions: DataTableRowAction<TData>[];
}

export function DataTableRowSelection<TData>({
    table,
    actions,
}: DataTableRowSelectionProps<TData>) {
  const [selectedAction, setSelectedAction] = useState<string | undefined>();
  const { t } = useTranslation();
  
  const handleGo = () => {
    const selectedRows = table.getSelectedRowModel().rows.map(r => r.original);
    const action = actions.find(action => action.value === selectedAction);

    if (action && selectedRows.length > 0) {
      action.onClick(selectedRows);
      table.resetRowSelection();
    }
  }

  return (
    <div className="flex items-center">
      <span className="text-sm mr-2">{t("With selected:")}</span>
      <Select value={selectedAction} onValueChange={setSelectedAction}>
        <SelectTrigger className="w-[180px]">
          <SelectValue placeholder={t("Select action")} />
        </SelectTrigger>
        <SelectContent>
            {actions.map(action => (
              <SelectItem key={action.value} value={action.value}>
                {action.label}
              </SelectItem>
            ))}
        </SelectContent>
      </Select>
      <Button size="sm" onClick={handleGo} disabled={!selectedAction} className="ml-2">{t("Go")}</Button>
    </div>
  )
}
