import { Table, TableHeader, TableRow, TableHead, TableBody, TableCell } from "@/components/ui/table";
import { Skeleton } from "@/components/ui/skeleton";

interface DataTableSkeletonProps {
  columns?: number;
  rows?: number;
}

export default function DataTableSkeleton({ columns = 5, rows = 10 }: DataTableSkeletonProps) {
  return (
    <div>
      <div className="flex flex-col gap-2 lg:flex-row lg:items-center lg:justify-between mb-2">
        <div className="flex flex-1 items-center space-x-2">
          <Skeleton className="h-8 max-w-sm w-[320px] rounded-md" />
        </div>
        <div>
          <Skeleton className="h-8 max-w-sm w-[320px] rounded-md" />
        </div>
      </div>
      <div className="rounded-md border bg-background">
        <Table>
          <TableHeader>
            <TableRow>
              {Array.from({ length: columns }).map((_, i) => (
                <TableHead key={i} className="py-3 px-2">
                  <Skeleton className="h-4 w-32 rounded" />
                </TableHead>
              ))}
            </TableRow>
          </TableHeader>
          <TableBody>
            {Array.from({ length: rows }).map((_, rowIdx) => (
              <TableRow key={rowIdx}>
                {Array.from({ length: columns }).map((_, colIdx) => (
                  <TableCell key={colIdx} className="py-3 px-2">
                    <Skeleton className="h-4 w-full rounded" />
                  </TableCell>
                ))}
              </TableRow>
            ))}
          </TableBody>
        </Table>
      </div>
    </div>
  );
}
