type SankeyNode = {
  id: string;
  name: string;
  category: 'source' | 'target' | 'other';
};

type SankeyLink = {
  source: number;
  target: number;
  value: number;
  sourceId?: string;
  targetId?: string;
};

export type SankeyData = {
  nodes: SankeyNode[];
  links: SankeyLink[];
};

export type CustomNodeProps = {
  x: number;
  y: number;
  width: number;
  height: number;
  payload: SankeyNode;
};

export type SankeyChartProps = {
  sankeyData: SankeyData | string | null;
  title?: string;
  width?: number;
  height?: number;
  className?: string;
  nodePadding?: number;
  isLoading?: boolean;
  maxNodes?: number;
  wasPreprocessed?: boolean;
}

export type SankeyChartWithDialogProps = {
  sankeyData: SankeyData | string | null;
  title?: string;
  width?: number;
  height?: number;
  className?: string;
  isLoading?: boolean;
  wasPreprocessed?: boolean;
}
