import { Button } from "./button"
import { Input } from "./input"
import { useState } from "react";
import { Eye, EyeOff } from "lucide-react";

export function PasswordInput({ placeholder, ...fields }: { placeholder?: string } & React.InputHTMLAttributes<HTMLInputElement>) {
    const [showPassword, setShowPassword] = useState(false);

    return (
        <div className="relative">
            <Input
                placeholder="••••••••••"
                type={showPassword ? "text" : "password"}
                {...fields} 
            />
            <Button
                type="button"
                variant="ghost"
                className="absolute right-0 top-0 h-full px-3"
                onClick={() => setShowPassword(!showPassword)}
            >
                {showPassword ? <EyeOff size={16} /> : <Eye size={16} />}
            </Button>
        </div>
    );
}