import { useTranslation } from 'react-i18next';
import { CodeBlockWithCopy } from '@/components/ui/CodeBlockWithCopy';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { useEnvironment } from '@/contexts/EnvironmentContext';

export function WiresharkInstall() {
  const { t } = useTranslation();
  const { environment } = useEnvironment();

  let command: string = '';
  if (environment?.distro?.includes('Ubuntu') || environment?.distro?.includes('Debian')) {
    command = `printf "wireshark-common wireshark-common/install-setuid boolean true" | sudo debconf-set-selections
sudo DEBIAN_FRONTEND=noninteractive apt-get install tshark -y
sudo mkdir -p /usr/local/wireshark
sudo mkdir -p /usr/local/wireshark/ringbuffer
sudo chown -R nna:nnacmd /usr/local/wireshark
sudo chmod -R 0775 /usr/local/wireshark
sudo chmod -R g+s /usr/local/wireshark
sudo groupadd -f wireshark
sudo usermod -a -G wireshark nna
sudo usermod -a -G wireshark www-data
`;
  } else if (
    environment?.distro?.includes('Red Hat Enterprise Linux') ||
    environment?.distro?.includes('Oracle Linux') ||
    environment?.distro?.includes('CentOS')
  ) {
    command = `sudo yum install wireshark-cli -y
sudo mkdir -p /usr/local/wireshark
sudo mkdir -p /usr/local/wireshark/ringbuffer
sudo chown -R nna:nnacmd /usr/local/wireshark
sudo chmod -R 0775 /usr/local/wireshark
sudo chmod -R g+s /usr/local/wireshark
sudo groupadd -f wireshark
sudo usermod -a -G wireshark nna
sudo usermod -a -G wireshark apache
`;
  }

  return (
    <Card className="mt-6 gap-2">
      <CardHeader>
        <CardTitle className="ml-3 text-xl font-bold">{t('Wireshark is not installed on this system')}</CardTitle>
      </CardHeader>
      <CardContent>
        <div className="flex pb-2">
          <Card className="m-2 w-1/2">
            <CardHeader>
              <CardTitle className="text-xl font-bold">{t('Description')}</CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-bg mt-2">
                {t(
                  'Wireshark is a free, open-source network protocol analyzer used to capture and inspect network traffic in real time. It supports hundreds of protocols and provides deep insight into network communications for troubleshooting, analysis, and security auditing.'
                )}
              </p>
            </CardContent>
          </Card>
          <Card className="m-2 w-1/2">
            <CardHeader>
              <CardTitle className="text-xl font-bold">{t('Features')}</CardTitle>
            </CardHeader>
            <CardContent>
              <ul className="mt-2 list-disc pl-6">
                <li>{t('Real-time network traffic analysis')}</li>
                <li>{t('Support for a wide range of protocols')}</li>
                <li>{t('Detailed packet inspection capabilities')}</li>
                <li>{t('Open-source and widely used in the industry')}</li>
              </ul>
            </CardContent>
          </Card>
        </div>
        <CodeBlockWithCopy>{command}</CodeBlockWithCopy>
      </CardContent>
    </Card>
  );
}
