export type ProtocolStatistics = {
  protocol: string;
  packet_count: number;
};

export type TopTalker = {
  ip: string;
  total_packets: number;
  total_bytes: number;
  tx_packets: number;
  tx_bytes: number;
  rx_packets: number;
  rx_bytes: number;
};

export type TopTalkersResponse = {
  top_transmitters: TopTalker[];
  top_receivers: TopTalker[];
};

export type CaptureInfo = {
  frames: number;
  bytes: number;
  duration: string;
  interface: string;
};

export type PacketSizeBucket = {
  range: string;
  count: number;
};

export type PacketSizeDistributionResponse = {
  packet_size_distribution: PacketSizeBucket[];
};
