import { useGetMergedPcap } from '@/components/wireshark/ringbuffer/queries';
import { PageLayout, PageHeader, PageTitle, PageSeparator } from '@/components/Page';
import { useTranslation } from 'react-i18next';
import { useGetRingBuffer } from '@/components/wireshark/ringbuffer/queries';
import RingBufferDataTable from '@/components/wireshark/ringbuffer//RingBufferDataTable';
import { Skeleton } from '@/components/ui/skeleton';
import { Button } from '@/components/ui/button';
import { useDownload } from '@/components/wireshark/ringbuffer/queries';
import { Download } from 'lucide-react';
import { Tooltip, TooltipTrigger, TooltipContent } from '@/components/ui/tooltip';
import { useSearchParams } from 'react-router';

export default function RingBufferViewPackets() {
  const { t } = useTranslation();
  const { data: ringBuffer } = useGetRingBuffer(1);
  const { data: mergedPcap, isLoading: isLoadingMergedPcap } = useGetMergedPcap(Number(ringBuffer ? ringBuffer.id : 0));
  const download = useDownload();
  const [params] = useSearchParams();
  const filter = params.get('filter') ?? '';

  const handleDownload = () => {
    download.mutate(mergedPcap?.id ?? 0);
  };

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t('Ring Buffer')} </PageTitle>
        {isLoadingMergedPcap ? (
          <div className="mt-1 flex w-full items-center justify-between">
            <div className="flex items-center space-x-2">
              <Skeleton className="h-6 w-32" />
              <Skeleton className="h-6 w-40" />
              <Skeleton className="h-6 w-40" />
            </div>
            <Skeleton className="h-10 w-10 rounded-lg" />
          </div>
        ) : (
          mergedPcap?.start_time &&
          mergedPcap?.end_time && (
            <div className="mt-1 flex w-full items-center justify-between">
              <div className="text-muted-foreground mt-1 text-lg font-medium">
                {t('Time Period')}: <span className="text-foreground font-semibold">{mergedPcap.start_time}</span> -{' '}
                <span className="text-foreground font-semibold">{mergedPcap.end_time}</span>
              </div>
              <Tooltip>
                <TooltipTrigger asChild>
                  <Button size="icon" onClick={handleDownload}>
                    <Download className="h-10 w-10" />
                  </Button>
                </TooltipTrigger>
                <TooltipContent>
                  <p>{t('Download')}</p>
                </TooltipContent>
              </Tooltip>
            </div>
          )
        )}
      </PageHeader>
      <PageSeparator />
      <RingBufferDataTable
        bufferId={mergedPcap?.id ?? 0}
        initialFileName={mergedPcap?.file_path ?? ''}
        initialFilter={filter}
      />
    </PageLayout>
  );
}
