import { Link } from 'react-router-dom';
import { PageLayout, PageHeader, PageTitle, PageDescription } from '@/components/Page';
import { Button } from '@/components/ui/button';
import { useTranslation } from 'react-i18next';

export default function NotFound() {
  const { t } = useTranslation();
  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>404 - {t('Page Not Found')}</PageTitle>
        <PageDescription>{t("The page you are looking for doesn't exist or has been moved.")}</PageDescription>
        <Link to="/">
          <Button>{t('Return to Dashboard')}</Button>
        </Link>
      </PageHeader>
    </PageLayout>
  );
}
