import { useTranslation } from 'react-i18next';
import { useAuth } from '@/contexts/AuthContext';
import ActivateLicenseForm from '@/components/administration/license/ActivateLicenseForm';
import TrialForm from '@/components/administration/license/TrialForm';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';

export default function ActivateLicense() {
  const { t } = useTranslation();
  const { license, isUserLoading, isLicenseLoading } = useAuth();

  if (isUserLoading || isLicenseLoading || !license)
    return <div className="flex h-screen items-center justify-center">{t('Loading...')}</div>;

  let title = '';
  let message = '';
  if (license.trial_expired && license.type !== 'licensed') {
    title = t('Your Trial Has Expired!');
    message = t('Please enter a valid license key or extend your trial to continue using Nagios Network Analyzer.');
  } else if (license.trial_expired && license.type === 'licensed' && !license.activated) {
    title = t('Your License Has Not Been Activated!');
    message = t('Please activate your license or extend your trial to continue using Nagios Network Analyzer.');
  }

  return (
    <div className="flex h-screen flex-col items-center justify-center px-5">
      <div className="mb-8 flex flex-col items-center gap-6">
        <h2 className="text-4xl font-bold">{title}</h2>
        <div className="flex flex-col gap-2">
          <p className="text-muted-foreground max-w-md text-center">{message}</p>
          <p className="text-muted-foreground max-w-md text-center">
            {t('If you do not have a license key, you can ')}
            <a
              href="https://www.nagios.com/products/nagios-network-analyzer/buy-now/"
              target="_blank"
              className="text-primary underline"
            >
              {t('purchase one')}
            </a>
            {t('.')}
          </p>
        </div>
      </div>

      <div className="min-h-[400px] w-full max-w-2xl">
        {license && (
          <Tabs defaultValue="activate" className="w-full">
            <TabsList className="grid w-full grid-cols-2">
              <TabsTrigger value="activate">{t('Activate License')}</TabsTrigger>
              <TabsTrigger value="extend">{t('Extend Trial')}</TabsTrigger>
            </TabsList>
            <TabsContent value="activate" className="mt-6">
              <ActivateLicenseForm showBadge={false} enableLicenseKey={true} />
            </TabsContent>
            <TabsContent value="extend" className="mt-6">
              <TrialForm />
            </TabsContent>
          </Tabs>
        )}
      </div>
    </div>
  );
}
