import { useTranslation } from 'react-i18next';
import DashboardDropdown from '@/components/dashboard/DashboardDropdown';
import { ChevronsUpDown, Frown, Plus } from 'lucide-react';
import { Button } from '@/components/ui/button';

export default function DashboardNotFound() {
  const { t } = useTranslation();

  return (
    <div className="animate-in fade-in-50 zoom-in-95 relative flex size-full items-center justify-center duration-300">
      <div className="relative grid size-[calc(100%-10rem)] min-h-120 grid-rows-3 place-items-center items-center justify-center rounded">
        <svg
          className="stroke-foreground absolute inset-0 z-0 size-full overflow-visible opacity-40"
          xmlns="http://www.w3.org/2000/svg"
        >
          <rect width="100%" height="100%" fill="none" strokeWidth="1" strokeDasharray="8,6" />
        </svg>
        <Plus className="absolute -top-[11px] -right-[11px]" />
        <Plus className="absolute -top-[11px] -left-[11px]" />
        <Plus className="absolute -right-[11px] -bottom-[11px]" />
        <Plus className="absolute -bottom-[11px] -left-[11px]" />
        <Frown className="z-10 size-30 self-end" />
        <div className="flex flex-col items-center">
          <p className="text-bold z-10 font-mono text-9xl">404</p>
          <p>{t("Sorry, we couldn't find that dashboard.")}</p>
        </div>
        <DashboardDropdown className="self-start">
          <Button className="z-10" variant="outline">
            {t('Manage Dashboards')}
            <ChevronsUpDown />
          </Button>
        </DashboardDropdown>
      </div>
    </div>
  );
}
