import { useTranslation } from 'react-i18next';
import { PageLayout, PageHeader, PageTitle, PageDescription, PageSeparator } from '@/components/Page';

export default function Help() {
  const { t } = useTranslation();
  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t('Getting Started With Nagios Network Analyzer')}</PageTitle>
        <PageDescription>
          {t(
            'The purpose of this help section is to get you started using Nagios Network Analyzer (NNA) and to direct you to documents, forums, and customer support if further help is needed. We have provided links to some of those areas along the left side.'
          )}
        </PageDescription>
        <PageDescription>
          {t('To get started using NNA we have a quick 2 step setup process to start collecting flow data.')}
        </PageDescription>
        <PageSeparator />
      </PageHeader>
      <div className="flex flex-col items-start gap-6 p-6 md:flex-row">
        {/* Main Content */}

        <section className="w-full md:w-5/6">
          <h3 className="text-xl font-semibold">{t('Step 1: Create a Flow Data Sender')}</h3>
          <p className="mb-2">
            {t(
              'To start using NNA you will need to have a flow data sender. A sender can be anything that will send flow data to an IP/Port using one of the flow types supported by NNA such as NetFlow or sFlow. If you do not already have senders set up, take a look at the help document(s) for the support netflow senders and how to set them up on switches, routers, Windows, Linux, and more.'
            )}
          </p>
          <p className="mb-4">
            {t(' Document on understanding flow data:')}{' '}
            <a
              href="https://library.nagios.com/library/products/nagios-network-analyzer/documentation/654-understanding-network-flows"
              className="text-primary hover:underline"
              target="_blank"
              rel="noopener noreferrer"
            >
              {t('Understanding Network Flows')}
            </a>
          </p>

          <p className="mb-4"> {t('How to set up flow data senders:')}</p>
          <ul className="mb-4 list-inside list-disc">
            <li>
              <a
                href="https://library.nagios.com/library/products/nagios-network-analyzer/documentation/658-configuring-switches-and-routers-to-send-netflow-data-to-nagios-network-analyzer"
                className="text-primary hover:underline"
                target="_blank"
                rel="noopener noreferrer"
              >
                {t('Routers')}
              </a>
            </li>
            <li>
              <a
                href="https://library.nagios.com/library/products/nagios-network-analyzer/documentation/652-installing-and-configuring-windows-netflow-exporters-for-network-analyzer"
                className="text-primary hover:underline"
                target="_blank"
                rel="noopener noreferrer"
              >
                {t('Windows Exporters')}
              </a>
            </li>
            <li>
              <a
                href="https://library.nagios.com/library/products/nagios-network-analyzer/documentation/659-configuring-a-linux-server-to-send-netflow-data-to-nagios-network-analyzer"
                className="text-primary hover:underline"
                target="_blank"
                rel="noopener noreferrer"
              >
                {t('Linux Exporters')}
              </a>
            </li>
          </ul>

          <p className="mb-6">
            {t(
              'Once you have flow data being generated and sent to the NNA IP address, we can create sources to capture that data and store it.'
            )}
          </p>

          <h3 className="mt-8 mb-2 text-xl font-semibold">{t('Step 2: Create a Source')}</h3>
          <p className="mb-2">
            {t(
              'Creating a source in NNA is pretty self explanatory but we will go over it quickly because there are a few parts that need to be pointed out since they may not be familiar with you. Start off by heading over to the sources tab. Click on the create source button above the table. Note that only admins can create or edit sources. Some of the noticeable points on this page are shown below.'
            )}
          </p>
          <ul className="mb-4 list-inside list-disc">
            <li>
              <strong>{t('Source Name:')}</strong> {t('Source names must be unique, and may not be changed once set.')}
            </li>
            <li>
              <strong>{t('Flow Source Description:')}</strong>{' '}
              {t('Use this to describe which switches, routers, or servers are sending to this source.')}
            </li>
            <li>
              <strong>{t('Listening Port:')}</strong>{' '}
              {t(
                'Ports must be unique, and must be a port over 1024. Each sender will need to be configured to send to a separate port.'
              )}
            </li>
            <li>
              <strong>{t('Incoming Flow Type:')}</strong> {t('The type of flow data being received.')}
            </li>
            <li>
              <strong>{t('Raw Data Lifetime:')}</strong>{' '}
              {t(
                'This value sets that length of time for granular data to be saved. This option was added to save disk space. In extreme conditions, sources can gather over 10GB of data in a day. This amount of data is so large that we compress and aggregate the data after the data lifetime to effectively keep the disk usage in check. The longer the data lifetime the longer you will have granular data but the more disk space you will use.'
              )}
            </li>
          </ul>
          <p>
            {t('Done! Once created you can stop/start the source at any time to stop or start the collection of data.')}
          </p>
        </section>

        {/* Sidebar */}
        <aside className="bg-sidebar text-sidebar-foreground border-sidebar-border w-full rounded-lg border px-4 py-3 shadow-sm md:w-1/4">
          <div className="space-y-4">
            <div>
              <h4 className="mb-2 text-lg font-semibold">{t('Resources')}</h4>
              <ul className="space-y-1">
                <li>
                  <a
                    href="https://support.nagios.com/kb/category.php?id=43"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="text-primary hover:underline"
                  >
                    {t('Knowledgebase')}
                  </a>
                </li>
                <li>
                  <a
                    href="https://support.nagios.com/forum/"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="text-primary hover:underline"
                  >
                    {t('Support Forum')}
                  </a>
                </li>
                <li>
                  <a
                    href="https://library.nagios.com"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="text-primary hover:underline"
                  >
                    {t('Documentation Library')}
                  </a>
                </li>
              </ul>
            </div>

            <div>
              <h4 className="mb-2 text-lg font-semibold">{t('Guides')}</h4>
              <ul className="space-y-1">
                <li>
                  <a
                    href="https://assets.nagios.com/downloads/nagios-network-analyzer/guides/nna-ag/"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="text-primary hover:underline"
                  >
                    {t('Admin Guide')}
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </aside>
      </div>
    </PageLayout>
  );
}
