import { PageLayout, PageHeader, PageTitle, PageDescription } from '@/components/Page';
import { useTranslation } from 'react-i18next';
import { useGetScan } from '@/components/nmap/scans/queries';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import Hosts from '@/components/nmap/scan/Hosts';
import Services from '@/components/nmap/scan/Services';
import ScanInfo from '@/components/nmap/scan/ScanInfo';
import RawOutput from '@/components/nmap/scan/RawOutput';
import { Badge } from '@/components/ui/badge';
import { ActivityIcon, BookOpenTextIcon, FileOutputIcon, ScanEye, ServerIcon } from 'lucide-react';
import { Skeleton } from '@/components/ui/skeleton';

export default function Scan() {
  const { t } = useTranslation();
  const id = window.location.pathname.split('/').pop() ?? '';
  const { data, isPending, isError } = useGetScan(id);

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>
          <span className="flex items-center gap-2">
            <ScanEye className="h-7 w-7" />
            {isPending ? <Skeleton className="h-8 w-80" /> : data?.title ? `${data.title}` : ''}
          </span>
        </PageTitle>
        <PageDescription>
          <div className="flex flex-wrap items-center gap-4">
            {isPending ? (
              <Skeleton className="h-6 w-96" />
            ) : (
              <>
                {data?.scan_parameters && (
                  <div className="flex items-center gap-2">
                    <span className="font-semibold">{t('Scan Parameters')}:</span>
                    <Badge variant="secondary" className="px-2 py-1 text-sm break-all">
                      {data.scan_parameters}
                    </Badge>
                  </div>
                )}
                {data?.profile && (
                  <div className="flex items-center gap-2">
                    <span className="font-semibold">{t('Profile')}:</span>
                    <Badge variant="secondary" className="px-2 py-1 text-sm">
                      {data.profile.name}
                    </Badge>
                  </div>
                )}
                {data?.scheduled_scan && (
                  <div className="flex items-center gap-2">
                    <span className="font-semibold">{t('Scheduled Scan')}:</span>
                    <Badge variant="secondary" className="px-2 py-1 text-sm">
                      {data.scheduled_scan.name}
                    </Badge>
                  </div>
                )}
              </>
            )}
          </div>
        </PageDescription>
      </PageHeader>
      <Tabs defaultValue="hosts" className="pt-6">
        <TabsList>
          <TabsTrigger value="hosts" className="gap-1.5">
            <ServerIcon className="h-4 w-4" />
            {t(`Hosts`)}
          </TabsTrigger>
          <TabsTrigger value="services" className="gap-1.5">
            <ActivityIcon className="h-4 w-4" />
            {t(`Services`)}
          </TabsTrigger>
          <TabsTrigger value="scaninfo" className="gap-1.5">
            <BookOpenTextIcon className="h-4 w-4" />
            {t(`Scan Info`)}
          </TabsTrigger>
          <TabsTrigger value="rawoutput" className="gap-1.5">
            <FileOutputIcon className="h-4 w-4" />
            {t(`Raw Output`)}
          </TabsTrigger>
        </TabsList>
        <TabsContent value="hosts">
          <Hosts data={data} isPending={isPending} isError={isError} />
        </TabsContent>
        <TabsContent value="services">
          <Services host={data?.json_results?.host ?? []} isPending={isPending} isError={isError} />
        </TabsContent>
        <TabsContent value="scaninfo">
          <ScanInfo jsonResults={data?.json_results} isPending={isPending} isError={isError} />
        </TabsContent>
        <TabsContent value="rawoutput">
          <RawOutput text={data?.scan_results || ''} isPending={isPending} isError={isError} />
        </TabsContent>
      </Tabs>
    </PageLayout>
  );
}
