import { PageLayout, PageHeader, PageTitle, PageDescription, PageSeparator } from '@/components/Page';
import { useTranslation } from 'react-i18next';
import { Button } from '@/components/ui/button';
import { Plus } from 'lucide-react';
import AddEditSourceDialog from '@/components/source/AddEditSourceDialog';
import { useGetSources } from '@/components/source/queries';
import SourcesDataTable from '@/components/source/SourcesDataTable';
import { useAuth } from '@/contexts/AuthContext';
import { hasPermission } from '@/components/role/utils';

export default function Sources() {
  const { t } = useTranslation();
  const { data, isLoading } = useGetSources();
  const { user } = useAuth();

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t('Flow Sources')}</PageTitle>
        <PageDescription>{t('Full list of flow sources in your system')}</PageDescription>
        <PageSeparator />
      </PageHeader>

      {/* Add Source Button */}
      {hasPermission(user?.role, 'flow_source_permissions', 'sources', 'post') && (
        <AddEditSourceDialog sources={data || []}>
          <Button className="mb-4">
            <Plus />
            {t('Create Flow Source')}
          </Button>
        </AddEditSourceDialog>
      )}

      <SourcesDataTable sources={data || []} isLoading={isLoading} />
    </PageLayout>
  );
}
