import { PageLayout, PageHeader, PageTitle, PageDescription } from '@/components/Page';
import { useTranslation } from 'react-i18next';
import { useCheckSuricata } from '@/components/suricata/queries';
import { SuricataInstall } from '@/components/suricata/SuricataInstall';
import { SuricataOverview } from '@/components/suricata/overview/SuricataOverview';
import { SuricataRules } from '@/components/suricata/rules/SuricataRules';
import { SuricataRulesets } from '@/components/suricata/rules/rulesets/SuricataRulesets';
import { SuricataAlerts } from '@/components/suricata/alerts/SuricataAlerts';
import { Skeleton } from '@/components/ui/skeleton';
import { SuricataDataTable } from '@/components/suricata/data/SuricataDataTable';
import { useSearchParams } from 'react-router';
import { AlertCircleIcon, ClipboardListIcon, ListOrderedIcon, PencilRulerIcon, SquareKanbanIcon } from 'lucide-react';
import ProtectedTabs from '@/components/role/ProtectedTabs';
import { ProtectedTabsType } from '@/components/role/types';

function HasSuricata() {
  const { t } = useTranslation();
  const [searchParams] = useSearchParams();
  const { data, isLoading, error } = useCheckSuricata();
  const dataFilter = searchParams.get('filter') || '';
  const alertFilter = searchParams.get('alertFilter') || '';

  const tabs: ProtectedTabsType<'suricata_permissions'> = [
    { value: 'overview', icon: ClipboardListIcon, title: t('Overview'), children: <SuricataOverview /> },
    {
      value: 'alerts',
      icon: AlertCircleIcon,
      title: t('Alerts'),
      children: <SuricataAlerts alertFilter={alertFilter} />,
      resource: 'alerts',
    },
    {
      value: 'data',
      icon: SquareKanbanIcon,
      title: t('Data'),
      children: <SuricataDataTable initialFilter={dataFilter} />,
      resource: 'data',
    },
    { value: 'rules', icon: PencilRulerIcon, title: t('Modify Rules'), children: <SuricataRules />, resource: 'rules' },
    {
      value: 'rulesets',
      icon: ListOrderedIcon,
      title: t('Manage Rulesets'),
      children: <SuricataRulesets />,
      resource: 'rulesets',
    },
  ];

  if (error) {
    console.error(error);
  }

  if (isLoading) {
    return (
      <div>
        <Skeleton className="my-4 h-9 w-[500px]" />
        <Skeleton className="h-[600px] w-full rounded-xl" />
      </div>
    );
  }

  if ((!data || data.version === 'None') && !isLoading) {
    return <SuricataInstall />;
  }
  return <ProtectedTabs integration="suricata_permissions" tabs={tabs} />;
}

export default function Suricata() {
  const { t } = useTranslation();
  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>Suricata</PageTitle>
        <PageDescription>{t('View and configure your Suricata instance')}</PageDescription>
      </PageHeader>
      <HasSuricata />
    </PageLayout>
  );
}
