import { useMemo } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { PageLayout, PageHeader, PageTitle, PageDescription, PageSeparator } from '@/components/Page';
import { ArrowLeft, ClipboardListIcon, SquareChartGanttIcon } from 'lucide-react';
import { useTranslation } from 'react-i18next';
import CaptureDataTable from '@/components/wireshark/captures/CaptureDataTable';
import { Tabs, TabsList, TabsContent, TabsTrigger } from '@/components/ui/tabs';
import CaptureSummary from '@/components/wireshark/capturesummary/CaptureSummary';
export default function Capture() {
  const id = useMemo(() => {
    return window.location.pathname.split('/').filter(Boolean).pop() ?? '';
  }, []);
  const navigate = useNavigate();
  const { t } = useTranslation();
  const [searchParams, setSearchParams] = useSearchParams();
  const filter = searchParams.get('filter') || '';
  const tab = searchParams.get('tab') || 'summary';

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>
          {t('Capture ID')}: {id}
        </PageTitle>
        <PageDescription>{t('Network traffic packets captured using Wireshark.')}</PageDescription>
      </PageHeader>
      <PageSeparator />

      <div
        className="hover:text-primary mb-6 flex w-fit cursor-pointer flex-wrap items-center gap-2 transition-colors duration-300 ease-in-out"
        onClick={() => navigate('/wireshark/?tab=history')}
      >
        <ArrowLeft className="h-4 w-4" />
        {t('Back to Capture History')}
      </div>
      <Tabs defaultValue={tab} value={tab}>
        <TabsList>
          <TabsTrigger value="summary" className="w-full gap-1.5" onClick={() => setSearchParams({ tab: 'summary' })}>
            <ClipboardListIcon className="h-4 w-4" />
            {t('Capture Summary')}
          </TabsTrigger>
          <TabsTrigger value="capture" className="w-full gap-1.5" onClick={() => setSearchParams({ tab: 'capture' })}>
            <SquareChartGanttIcon className="h-4 w-4" />
            {t('Capture Data')}
          </TabsTrigger>
        </TabsList>
        <TabsContent value="summary">
          <CaptureSummary captureId={id} />
        </TabsContent>
        <TabsContent value="capture">
          <CaptureDataTable captureId={id} defaultFilter={filter} />
        </TabsContent>
      </Tabs>
    </PageLayout>
  );
}
