#!/bin/bash
#
# Bash script that removes source files
# Copyright 2017-2025 Nagios Enterprises, LLC. All Rights reserved.
#

BACKENDDIR="/usr/local/nagiosna"
SOURCEDIR="$1"
PORT="$2"

if [ ! -d "$SOURCEDIR" ]; then
    echo "Warning: Source directory does not exist: $SOURCEDIR"
fi

if [ -d "$SOURCEDIR" ]; then
    rm -rf "$SOURCEDIR"
    if [ $? -eq 0 ]; then
        echo "Removed source directory: $SOURCEDIR"
    else
        echo "Error: Failed to remove source directory: $SOURCEDIR"
        exit 1
    fi
else
    echo "Source directory already removed or does not exist: $SOURCEDIR"
fi

"$BACKENDDIR/scripts/manage_firewall.sh" -p "$PORT" -t udp --rem

exit 0
