#!/bin/bash

echo "Installing Chrome for Testing"

ZIP_URL="https://storage.googleapis.com/chrome-for-testing-public/140.0.7339.82/linux64/chrome-linux64.zip"
ZIP_NAME="chrome-linux64.zip"
INSTALL_DIR="/var/www/html/nagiosna/exporting"
CHROME_DIR="${INSTALL_DIR}"
TMP_DIR="/tmp/chrome-install"

mkdir -p "${TMP_DIR}"
cd "${TMP_DIR}"
curl -LO "$ZIP_URL"
unzip -q "${ZIP_NAME}"
mkdir -p "${CHROME_DIR}"
mv chrome-linux64 "${CHROME_DIR}"

# Install system-level deps according to: https://github.com/GoogleChromeLabs/chrome-for-testing
if [[ "$distro" == "Ubuntu" || "$distro" == "Debian" ]]; then
  DEPS_FILE="${INSTALL_DIR}/chrome-linux64/deb.deps"
  while read -r pkg; do
    apt-get satisfy -y --no-install-recommends "${pkg}"
  done < "$DEPS_FILE"

# Running dnf provides on all of the deps takes way too long - I ran it once and listed them out below
elif [[ "$dist" == "el9" || "$dist" == "el10" ]]; then
  dnf install -y libdrm ca-certificates glibc libX11 libXcomposite libXdamage libXext libXfixes libXrandr alsa-lib atk at-spi2-atk at-spi2-core cairo cups-libs libcurl dbus-libs liberation-fonts expat mesa-libgbm libgcc glib2 gtk3 nspr nss nss-util pango systemd-libs vulkan-loader libxcb libxkbcommon wget xdg-utils
fi

rm -rf "${TMP_DIR}"

echo "Chrome for Testing successfully installed at ${CHROME_DIR}"