<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\MaintenanceService;
use Illuminate\Support\Facades\Log;

class CheckMaintenanceCommand extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'maintenance:check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check the remaining maintenance time by calling the Nagios API.';

    /**
     * The MaintenanceService instance.
     * 
     * @var MaintenanceService
     */
    protected MaintenanceService $maintenance;

    /**
     * Create a new command instance.
     *
     * @param MaintenanceService $maintenance The MaintenanceService instance.
     * @return void
     */
    public function __construct(MaintenanceService $maintenance)
    {
        parent::__construct();
        $this->maintenance = $maintenance;
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Checking maintenance...');

        // Force check the maintenance
        $this->maintenance->check(true);
        $status = $this->maintenance->isExpired() ? 'Expired' : 'Active';
        $days_left = $this->maintenance->getDaysLeft();
        
        $this->info("Maintenance check complete. Status: " . $status . ". Days left: " . $days_left);
        Log::info('[CheckMaintenance]: Maintenance checked.', [
            'is_maintenance_expired' => $this->maintenance->isExpired(), 
            'days_left' => $days_left
        ]);
    }
}
