<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\PruneSuricataDataJob;
use Illuminate\Support\Facades\Log;

class PruneSuricataDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'suricata:prune-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Prunes suricata data based on retention settings';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        PruneSuricataDataJob::dispatch();
        Log::info("Dispatched the prune job for suricata data.");
    }
}
