<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\SyncRulesetsJob;

class SyncRulesetCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rulesets:sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Syncs custom rulesets into the db';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info("Dispatching Suricata update job to sync rulesets.");
 
        dispatch(new SyncRulesetsJob());

        $this->info("Job completed.");
    }
}
