<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\BroadcastsEvents;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Casts\Attribute;
use App\Models\NmapScheduledScan;

class NmapScan extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'nmap_scans';

    /**
     * Cast started_at and finished_at into ISO 8601 format to match the format of created_at and updated_at.
     */
    protected $casts = [
        'started_at' => 'datetime:Y-m-d\TH:i:s.u\Z',
        'finished_at' => 'datetime:Y-m-d\TH:i:s.u\Z',
    ];

    /**
     * The attributes that are mass assignable.
     * 
     * @var list<string>
     */
    protected $fillable = [
        'user_id',
        'nmap_profile_id',
        'scheduled_nmap_scan_id',
        'started_at',
        'finished_at',
        'title',
        'status',
        'output_filename',
        'scan_parameters',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function profile(): BelongsTo
    {
        return $this->belongsTo(NmapProfile::class, 'nmap_profile_id');
    }

    public function scheduledScan(): BelongsTo
    {
        return $this->belongsTo(NmapScheduledScan::class, 'scheduled_nmap_scan_id');
    }

    public function ndiff1(): HasMany
    {
        return $this->hasMany(Ndiff::class, 'scan1_id');
    }

    public function ndiff2(): HasMany
    {
        return $this->hasMany(Ndiff::class, 'scan2_id');
    }

    public function ndiffs(): Attribute
    {
        return Attribute::get(fn () =>
            $this->ndiff1->merge($this->ndiff2)
        );
    }
}
