<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\NagiosServer;

class ServiceHostname extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'hostname',
        'servicename',
        'server_id',
    ];

    public function nagiosServer(): BelongsTo
    {
        return $this->belongsTo(NagiosServer::class, 'server_id');
    }

    /**
     * get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'server_id' => 'integer',
        ];
    }
}
