<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Source extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'name',
        'port',
        'description',
        'flowtype',
        'directory',
        'lifetime',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'port' => 'integer',
        ];
    }

    public function sourceGroups()
    {
        return $this->belongsToMany(
            SourceGroup::class,
            'source_group_linker',
            'source_id',
            'source_group_id'
        );
    }

    public function getFlowsDirectory()
    {
        return rtrim($this->directory, '/') . '/flows/';
    }

    public function checks()
    {
        return $this->morphMany(Check::class, 'object', 'object_type', 'object_id');
    }

    protected static function booted()
    {
        static::deleting(function ($source) {
            $source->checks()->delete();
        });
    }
}
