<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SourceGroup extends Model
{
    protected $fillable = [
        'name',
        'description',
    ];

    public function sources()
    {
        return $this->belongsToMany(
            Source::class,
            'source_group_linker', 
            'source_group_id',      // Foreign key for this model
            'source_id'             // Foreign key for related model
        );
    }

    public function getFlowsDirectory(): string
    {
        $sources = $this->sources;

        if ($sources->isEmpty()) {
            return '';
        }

        $directories = [];
        foreach ($sources as $index => $source) {
            $baseDir = rtrim($source->directory, '/');

            if ($index === 0) {
                $directories[] = "{$baseDir}/flows/";
            } else {
                $relativeName = basename($baseDir);
                $directories[] = "../../{$relativeName}/flows/";
            }
        }

        return implode(':', $directories);
    }

    public function checks()
    {
        return $this->morphMany(Check::class, 'object', 'object_type', 'object_id');
    }

    protected static function booted()
    {
        static::deleting(function ($group) {
            $group->checks()->delete();
        });
    }
}
