<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SuricataJson extends Model
{
    protected $table = 'suricata_json';

    protected $fillable = [
        'path',
        'is_scanning',
    ];

    protected $casts = [
        'is_scanning' => 'boolean',
    ];

    /**
     * All Suricata data rows that belong to this JSON file.
     */
    public function data()
    {
        return $this->hasMany(SuricataData::class, 'json_id');
    }
}
