<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SuricataScan extends Model
{
    protected $table = "suricata_scan";

    public $timestamps = false;

    protected $fillable = [
        'pid',
        'running',
        'last_rotated',
        'started_at',
        'eve_current_line',
        'current_eve_log',
        'interface'
    ];

    protected $casts = [
        'running' => 'boolean',
        'last_rotated' => 'datetime',
        'started_at' => 'datetime',
    ];

    public function isRunning(){
        return $this->running;
    }
}
