<?php

namespace App\Notifications;

use Illuminate\Auth\Notifications\ResetPassword;

class ResetPasswordUsername extends ResetPassword
{
    /**
     * Build the reset URL using username instead of email.
     */
    protected function resetUrl($notifiable)
    {
        return url(route('password.reset', [
            'token' => $this->token,
            'username' => $notifiable->username,
        ], false));
    }
}
