<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;

class AdminRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * This seeder ensures the admin role always exists at id=1.
     */
    public function run(): void
    {
        $adminRoleData = [
            'id' => 1,
            'name' => 'Admin',
            'type' => 'admin',
            'protected' => true,
            'flow_source_permissions' => [
                'sources' => ['get', 'put', 'post', 'delete'],
                'sourcegroups' => ['get', 'put', 'post', 'delete'],
                'start_stop_sources' => true,
                'start_stop_sourcegroups' => true,
            ],
            'suricata_permissions' => [
                'rules' => ['get', 'put', 'post', 'delete'],
                'rulesets' => ['get', 'put', 'post', 'delete'],
                'config' => true,
                'start_stop_scan' => true,
                'data' => ['get', 'put', 'post', 'delete'],
                'scan_pcap' => true,
                'alerts' => true,
            ],
            'wireshark_permissions' => [
                'pcaps' => ['get', 'put', 'post', 'delete'],
                'ring_buffer' => ['get', 'put', 'post', 'delete'],
                'start_stop_capture' => true,
                'start_stop_ring_buffer' => true,
            ],
            'nmap_permissions' => [
                'scans' => ['get', 'put', 'post', 'delete'],
                'scheduled_scans' => ['get', 'put', 'post', 'delete'],
                'profiles' => ['get', 'put', 'post', 'delete'],
                'ndiffs' => ['get', 'put', 'post', 'delete'],
            ],
        ];

        $existingRole = Role::where('type', 'admin')->first();
        if ($existingRole) {
            $existingRole->update($adminRoleData);
        } else {
            Role::create($adminRoleData);
        }
    }
}
