<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AssignRolesToExistingUsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin_role_id = DB::table('roles')->where('name', 'Admin')->value('id');
        $user_role_id = DB::table('roles')->where('name', 'User')->value('id');

        DB::table('users')
            ->where('is_admin', 1)
            ->update(['role_id' => $admin_role_id]);

        DB::table('users')
            ->where('is_admin', 0)
            ->update(['role_id' => $user_role_id]);
    }
}
