<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;

class UpdateAPIKeysForMigratedUsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::whereNotNull('apikey_id')
            ->where('legacy_password', 1)
            ->each(function ($user) {
                $user->tokens()->delete();

                $token = $user->createToken('apikey', ['api:access']);
                $user->apikey = $token->plainTextToken;
                $user->apikey_id = $token->accessToken->id; 
                $user->save();
            });
    }
}
