<?php

use Illuminate\Support\Facades\Broadcast;
use App\Models\User;

Broadcast::channel('NNA.Admins', function (User $user) {
    \Log::info('Broadcast auth for NNA Admins channel', [
        'user_id' => $user->id,
        'is_admin' => $user->isAdmin(),
        'return' => 1 === $user->isAdmin(),
    ]);

    return $user->isAdmin();
});

Broadcast::channel('NNA.Users', function (User $user) {
    return true;
});

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return true;
});
