import { AppSidebar } from "@/components/AppSideBar";
import {
  SidebarInset,
  SidebarProvider,
} from "@/components/ui/sidebar"
import { Header } from "@/components/header/Header"
import { AppToaster } from "@/components/AppToaster"
import { PageContainer } from "@/components/Page";
import { Banner } from "@/components/Banner";
import { Outlet } from "react-router-dom";

export default function Layout() {
  return (
    <div className="flex flex-col h-screen">
      <Banner />
      <SidebarProvider className="flex-1 min-h-0">
        <AppSidebar />
        <SidebarInset className="overflow-hidden">
          <Header />
          <PageContainer>
            <Outlet />
          </PageContainer>
          <AppToaster />
        </SidebarInset>
      </SidebarProvider>
    </div>
  )
}
