import { cn } from "@/lib/utils";
import React from "react";
import { useSidebar } from "@/components/ui/sidebar";
import { useIsMobile } from "@/hooks/use-mobile";

export function PageContainer({ children }: { children: React.ReactNode }) {
  const { open } = useSidebar();
  const isMobile = useIsMobile();
  return (
    <div className={`${isMobile ? "w-screen" : open ? "w-[calc(100vw-var(--sidebar-width))]" : "w-[calc(100vw-48px)]"} transition-[width] [transition-duration:200ms] ease-linear overflow-auto h-full max-h-[calc(100vh-3.5rem)] bg-background`}>
      {children}
    </div>
  )
}

export function PageLayout({ children }: { children: React.ReactNode }) {
  return (
    <div className="h-fit w-full px-20 py-10">{children}</div>
  )
}

export function PageHeader({ children }: { children: React.ReactNode }) {
  return <div className="space-y-4">{children}</div>
}

export function PageTitle({ children, className }: { children: React.ReactNode, className?: string }) {
  return <div className={cn("text-foreground text-2xl font-semibold", className)}>{children}</div>
}

export function PageDescription({ children }: { children: React.ReactNode }) {
  return <div className="text-base text-muted-foreground">{children}</div>
}

export function PageSeparator({ className }: { className?: string }) {
  return <div className={cn(`w-full my-6 border-b border-border`, className)} />
}

export function PageSectionTitle({ children }: { children: React.ReactNode }) {
  return <div className="text-foreground text-xl font-semibold">{children}</div>
}

export function PageSectionDescription({ children, className }: { children: React.ReactNode, className?: string }) {
  return <div className={cn("text-sm text-muted-foreground", className)}>{children}</div>
}