import { useTranslation } from 'react-i18next';

export function obfuscateKey(key: string): string {
  if (!key || key.length <= 6) {
    return key;
  }

  const lastSixChars = key.slice(-6);
  const charsToObfuscate = key.slice(0, -6);
  
  const obfuscated = charsToObfuscate
    .split('')
    .map(char => char === '-' ? '-' : 'X')
    .join('');
  
  return obfuscated + lastSixChars;
}

export function useTranslateError() {
  const { t } = useTranslation();

  return (title: string, message: string): { title: string; message: string } => {
    const errorMap: Record<string, { title: string; message: string }> = {
      'Deactivated': {
        title: t('Deactivated'),
        message: t('This license key has been deactivated. Contact <a href=\'http://www.nagios.com/contact/\'>sales</a> for more information.'),
      },
      'Maintenance expired': {
        title: t('Maintenance expired'),
        message: message.includes('do not currently have')
          ? t('You do not currently have maintenance for the specified license key. Before you can activate the license key, you must purchase maintenance.')
          : t('Your maintenance for the specified license key has expired. Before you can activate the license key, you must renew your maintenance.'),
      },
      'Max activations exceeded': {
        title: t('Max activations exceeded'),
        message: t('You have exceeded the maximum allowed activations for the specified license key.'),
      },
      'Invalid address': {
        title: t('Invalid address'),
        message: t('The address is invalid. You must enter a valid IP address for your Nagios XI server.'),
      },
    };

    return errorMap[title] || { title, message };
  };
}
