export const thresholdRegex = /^((~|@)?(\d+:\d*|\d+|:\d+))?$/;

// Checks if start <= end
export function isThresholdValid(threshold: string){
  const sanitized = threshold.replace(/~/g, '-');

  const range = sanitized.match(/-?\d+/g)?.map(Number);

  // Assumes invalid thresholds have already been caught by thresholdRegex and Zod
  if (!range || range.length !== 2){
    return true;
  }

  const [start, end] = range;

  if (start > end){
    return false;
  }
  return true;
}
