import { AddDashletDialog } from "@/components/dashboard/dashlet/AddEditDashletDialog";
import { CirclePlus } from "lucide-react";

export default function AddDashletPlaceholder({ dashboardId }: { dashboardId: number }) {
  return (
    <AddDashletDialog dashboardId={dashboardId}>
      <div key={dashboardId} className="h-[390px] w-[646px] relative flex items-center justify-center hover:cursor-pointer group/placeholder rounded-xl animate-in fade-in-50 zoom-in-95">
        <svg
          className="absolute inset-0 size-full z-0 overflow-visible stroke-foreground opacity-40 transition-opacity group-hover/placeholder:opacity-100"
          xmlns="http://www.w3.org/2000/svg"
        >
          <rect
            width="100%"
            height="100%"
            fill="none"
            strokeWidth="1"
            strokeDasharray="6,8"
            rx="16"
            ry="16"
          />
        </svg>
        <CirclePlus className="size-10 opacity-40 group-hover/placeholder:opacity-100 transition-opacity" />
      </div>
    </AddDashletDialog>
  );
}
