import { dashlet } from "@/components/dashboard/types";
import {
  DropdownMenu,
  DropdownMenuTrigger,
  DropdownMenuContent,
  DropdownMenuItem,
} from '@/components/ui/dropdown-menu';
import { Ellipsis } from 'lucide-react';
import { Dialog, DialogTrigger } from '@/components/ui/dialog';
import { EditDashletDialog } from "@/components/dashboard/dashlet/AddEditDashletDialog";
import { useDeleteDashlet } from "@/components/dashboard/dashlet/queries";
import { Card, CardHeader, CardTitle, CardDescription, CardContent } from "@/components/ui/card";
import { useState } from "react";
import { dashletMap } from "@/components/dashboard/dashlet/map";
import { useDashboard } from "@/components/dashboard/DashboardContext";
import { useTranslation } from "react-i18next";

export default function Dashlet({
  dashlet,
  isLoading,
  isExporting
}: {
  dashlet: dashlet;
  isLoading: boolean;
  isExporting?: boolean;
}) {

  const { t } = useTranslation();
  const { range } = useDashboard().dashboard;
  const deleteDashletMutation = useDeleteDashlet();
  const [open, setOpen] = useState(false);

  const { component: Content } = dashletMap[dashlet.vis_options.type];

  return (
    <Card className="h-full w-full overflow-hidden py-0 gap-0 @container/card border-border bg-background">
      <CardHeader className={`${!isLoading && "draggable hover:bg-card/50 hover:cursor-move"} flex justify-between py-3 px-4 transition-colors duration-200`}>
        <div className="space-y-1">
          <CardTitle>
            {dashlet.title}
          </CardTitle>
          <CardDescription>
            {dashlet.description}
          </CardDescription>
        </div>
        <Dialog open={open} onOpenChange={setOpen}>
          <DropdownMenu>
            <DropdownMenuTrigger className="outline-none">
              <Ellipsis className="size-4" />
            </DropdownMenuTrigger>
            <DropdownMenuContent>
              <DialogTrigger asChild>
                <DropdownMenuItem>{t("Edit")}</DropdownMenuItem>
              </DialogTrigger>
              <DropdownMenuItem onClick={() => deleteDashletMutation.mutate({ id: dashlet.id, dashboard_id: dashlet.dashboard_id })}>{t("Delete")}</DropdownMenuItem>
            </DropdownMenuContent>
          </DropdownMenu>
          <EditDashletDialog dashlet={dashlet} setOpen={setOpen} />
        </Dialog>
      </CardHeader>
      <CardContent className="w-full h-[calc(100%-4.25rem)] px-4 overflow-auto">
        <Content {...dashlet.data_options} range={range} isExporting={isExporting ?? false} />
      </CardContent>
    </Card>
  )
}