import { Button } from "@/components/ui/button";
import { Download } from "lucide-react";
import axios from "@/lib/axios";
import { useMutation } from "@tanstack/react-query";
import {
  AlertDialog,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
} from "@/components/ui/alert-dialog";
import { useTranslation } from "react-i18next";
import { Loader2Icon, Image, FileText } from "lucide-react"
import {
  HoverCard,
  HoverCardContent,
  HoverCardTrigger,
} from "@/components/ui/hover-card"
import { useState } from "react";

export default function ExportHoverCard({ dashboardId }: { dashboardId: number }) {

  const { t } = useTranslation();
  const [extension, setExtension] = useState('');
  const { mutate, isPending, reset } = useMutation({
    mutationFn: (type: string) => {
      setExtension(type);
      return axios.post(`/api/v1/export/${dashboardId}`, { type: type });
    },
    onSuccess: async (response) => {
      window.open(`/storage/${response.data.filename}`, '_blank');
    },
  });

  return (
    <>
      <AlertDialog open={isPending}>
        <AlertDialogContent>
          <AlertDialogHeader>
            <AlertDialogTitle className="flex gap-2 items-center">
              {t("Generating")}
              <span> {extension.toUpperCase()}</span>
              <Loader2Icon className="animate-spin" />
            </AlertDialogTitle>
            <AlertDialogDescription>
              {t("This may take a moment.")}
            </AlertDialogDescription>
          </AlertDialogHeader>
          <AlertDialogFooter>
            <AlertDialogCancel onClick={() => reset()}>{t("Close")}</AlertDialogCancel>
          </AlertDialogFooter>
        </AlertDialogContent>
      </AlertDialog>
      <HoverCard openDelay={50} closeDelay={50}>
        <HoverCardTrigger asChild>
          <Button variant="ghost" size="sm">
            <Download  />
            {t("Download")}
          </Button>
        </HoverCardTrigger>
        <HoverCardContent className="w-fit flex flex-col p-1">
            <Button variant="ghost" size="sm" onClick={() => mutate('pdf')}>
              <FileText /> PDF
            </Button>
            <Button variant="ghost" size="sm" onClick={() => mutate('jpg')}>
              <Image /> JPG
            </Button>
        </HoverCardContent>
      </HoverCard>
    </>
  )
}