import { useTranslation } from "react-i18next";
import { CodeBlockWithCopy } from "@/components/ui/CodeBlockWithCopy";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { useEnvironment } from "@/contexts/EnvironmentContext";

export default function NmapInstall() {
  const { t } = useTranslation();
  const { environment } = useEnvironment();
  let command = "";
  
  if (environment?.distro?.includes("Ubuntu") || environment?.distro?.includes("Debian")) {
    command = `sudo apt install nmap -y
sudo curl https://raw.githubusercontent.com/NagiosEnterprises/nmap-nagios/refs/heads/master/ndiff/ndiff.py -o /usr/local/bin/ndiff
sudo chmod +x /usr/local/bin/ndiff
sudo setcap cap_net_raw,cap_net_admin,cap_net_bind_service+eip /usr/bin/nmap
sudo mkdir -p /usr/local/nmap
sudo mkdir -p /usr/local/nmap/ndiff
sudo chown -R nna:nnacmd /usr/local/nmap
sudo chmod -R 775 /usr/local/nmap
`;
  } else {
    command = `sudo dnf install nmap -y
sudo curl https://raw.githubusercontent.com/NagiosEnterprises/nmap-nagios/refs/heads/master/ndiff/ndiff.py -o /usr/local/bin/ndiff
sudo chmod +x /usr/local/bin/ndiff
sudo setcap cap_net_raw,cap_net_admin,cap_net_bind_service+eip /usr/bin/nmap
sudo mkdir -p /usr/local/nmap
sudo mkdir -p /usr/local/nmap/ndiff
sudo chown -R nna:nnacmd /usr/local/nmap
sudo chmod -R 775 /usr/local/nmap
`;
  }
  return (
    <Card className="mt-6 gap-2">
      <CardHeader>
        <CardTitle className="text-xl font-bold ml-3">
          {t(
            "Nmap is not installed on this system"
          )}
        </CardTitle>
      </CardHeader>
      <CardContent>
        <div className="flex pb-2">
          <Card className="w-1/2 m-2">
            <CardHeader>
              <CardTitle className="text-xl font-bold">{t('Description')}</CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-bg mt-2">
                {t("Nmap provides powerful network scanning capabilities that help you maintain visibility into the devices and services running in your environment. By scheduling scans and automatically comparing results with ndiff, you can quickly detect newly added or removed hosts, track changes to your network, and identify potential security risks.")}
              </p>
            </CardContent>
          </Card>
          <Card className="w-1/2 m-2">
            <CardHeader>
              <CardTitle className="text-xl font-bold">{t('Features')}</CardTitle>
            </CardHeader>
            <CardContent>
              <ul className="list-disc pl-6 mt-2">
                <li>{t('Discover hosts and services across your network with fast, accurate scans.')}</li>
                <li>{t('Schedule recurring scans to maintain up-to-date visibility.')}</li>
                <li>{t('Use ndiff to detect newly added or removed devices after each scan.')}</li>
                <li>{t('Identify open ports and exposed services that may pose security risks.')}</li>
                <li>{t('View historical scan results to monitor changes in your network environment.')}</li>
              </ul>
            </CardContent>
          </Card>
        </div>
        <CodeBlockWithCopy>{command}</CodeBlockWithCopy>
      </CardContent>
    </Card>
  );
}