import { useTranslation } from 'react-i18next';
import InfoCard from '@/components/ui/InfoCard';
import { Card, CardContent } from '@/components/ui/card';
import { Hash, Scan } from "lucide-react";
import { Skeleton } from "@/components/ui/skeleton"
import { useGetNmapOverview } from "@/components/nmap/overview/queries";
import { useNavigate } from "react-router-dom"
import { NmapScansOverTimeBarChart } from '@/components/nmap/overview/ScansOverTimeBarChart';
import { ScheduledScansChart } from '@/components/nmap/overview/ScheduledScansChart'

export default function Overview() {
  const { t } = useTranslation();
  const { data: overviewData, isLoading: isLoadingOverview } = useGetNmapOverview();
  const navigate = useNavigate();

  if (isLoadingOverview) {
    return (
      <Card>
        <CardContent>
          <div className="w-full flex gap-4 mb-4">
            <Skeleton className="h-45 w-1/2" />
            <Skeleton className="h-45 w-1/2" />
          </div>
          <div className="flex">
            <Skeleton className="h-80 w-2/5 mr-4" />
            <Skeleton className="h-80 w-3/5 ml-4" />
          </div>
        </CardContent>
      </Card>
    );
  }

  return (
    <Card>
      <CardContent>
        <div className="w-full flex flex-col gap-4">
          <div className="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-4 gap-4">
            <InfoCard
              header={t('Total Scans')}
              data={overviewData?.total_scans.toString() || '0'}
              icon={<Hash />}
              tooltip={t('Total number of Scans.')}
            />
            <InfoCard
              header={t('Total Ndiffs')}
              data={overviewData?.total_ndiffs || '0'}
              icon={<Hash />}
              tooltip={t('Total number of Ndiffs.')}
            />
            <InfoCard
              header={t('Total Scheduled Scans')}
              data={overviewData?.total_scheduled_scans || '0'}
              icon={<Hash />}
              tooltip={t('Total number of Scheduled Scans.')}
            />
            <InfoCard
              className={`transition-transform 
                  ${overviewData?.most_recent_scan?.id ? "cursor-pointer rounded-xl hover:bg-accent hover:shadow-lg hover:scale-102" : "opacity-50 pointer-events-none"}`}
              onClick={() => navigate(`/nmap/scan/${overviewData?.most_recent_scan?.id}`)}
              header={t('Most Recent Scan')}
              data={overviewData?.most_recent_scan?.title || '0'}
              icon={<Scan />}
              tooltip={t('The most recent scan.')}
            />
          </div>
          <div className="grid grid-cols-6 gap-4">
            <div className="col-span-3">
              <NmapScansOverTimeBarChart data={overviewData?.scan_in_last7days ?? []} />
            </div>
            <div className="col-span-3">
              <ScheduledScansChart data={overviewData?.scheduled_scans ?? []} />
            </div>
          </div>
        </div>
      </CardContent>
    </Card>
  );
}
