import { useQuery } from '@tanstack/react-query';
import axios from "@/lib/axios";

export function useGetNmapVersion() {
  return useQuery({
    queryKey: ['nmap_version'],
    queryFn: async () => {
      const response = await axios.get('/api/v1/nmap/version');
      return response.data;
    },
    staleTime: 5 * 60 * 1000, // 5 minutes
  });
}
