import { useTranslation } from 'react-i18next';
import { 
    Card, 
    CardContent, 
} from "@/components/ui/card";

type RawOutputProps = {
  text: string;
  isPending?: boolean;
  isError?: boolean;
}

export default function RawOutput({ text, isPending, isError }: RawOutputProps) {
  const { t } = useTranslation();

  if (isPending) {
    return <Card><CardContent>{t('Loading...')}</CardContent></Card>;
  }

  if (isError || !text) {
    return <Card><CardContent>{t('Failed to load scan.')}</CardContent></Card>;
  }

  return (
    <Card>
      <CardContent>
        <pre className="whitespace-pre-wrap font-mono text-sm relative">
          {text}
        </pre>
      </CardContent>
    </Card>
  );
}