export type Port = {
  protocol: string;
  portid: string;
  state: {
    state: string;
    reason: string;
    reason_ttl: string;
  };
  service: {
    name: string;
    method: string;
    conf: string;
    version?: string;
  };
}

export type Address = {
  addr: string; 
  addrtype: string; 
  vendor?: string 
}

export type Host = {
  address: Address | Address[];
  status: {
    state: string;
    reason: string;
    reason_ttl: string;
  };
  ports: {
    port: Port | Port[];
  };
  hostnames?: {
    hostname: {
      name: string;
      type?: string;
    }
  };
  times: {
    rttvar: string;
    srtt: string;
    to: string;
  };
}